<?php
/**
 * File: update_inspection.php
 * تحديث ديناميكي لجدول inspections — يشمل كل الأعمدة الممكنة (ما عدا: id, sn المُولّد)
 */

require_once __DIR__ . '/config.php';

if (!isset($pdo)) {
  if (!isset($dsn, $db_user, $db_pass)) die('DB config missing');
  $pdo = new PDO($dsn, $db_user, $db_pass, [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    PDO::MYSQL_ATTR_INIT_COMMAND => 'SET NAMES utf8mb4'
  ]);
}

$id = isset($_POST['id']) ? (int)$_POST['id'] : 0;
if ($id <= 0) die('معرّف غير صالح');

$desc = $pdo->query('DESCRIBE inspections')->fetchAll();
$allowed = [];
foreach ($desc as $c) {
  $f = $c['Field'];
  if (strtolower($f) === 'id') continue;          // لا نحدّث id
  if (strtolower($f) === 'sn') continue;          // عمود مُولَّد VIRTUAL
  $allowed[$f] = $c['Type'];
}

$set = [];
$params = [];
foreach ($allowed as $field => $type) {
  if (!array_key_exists($field, $_POST)) continue;
  $val = $_POST[$field];
  // تحويل للتواريخ/الوقت لو احتاج
  $t = strtolower($type);
  if (str_contains($t,'datetime')) {
    // نتوقع قيمة بصيغة Y-m-dTH:i من input type=datetime-local
    if ($val !== '' && preg_match('/^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}$/', $val)) {
      $val = str_replace('T',' ',$val).':00';
    }
  } elseif (str_contains($t,'date')) {
    // نتركها Y-m-d كما هي
  }
  $set[] = "`$field` = ?";
  $params[] = $val;
}

if (!$set) die('لا توجد حقول لتحديثها');
$params[] = $id;
$sql = 'UPDATE inspections SET '.implode(', ', $set).' WHERE id = ?';
$st = $pdo->prepare($sql);
$st->execute($params);

echo "<meta charset='utf-8'><script>alert('تم حفظ التعديلات بنجاح'); history.back();</script>";
