<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once __DIR__ . '/config.php';
require_once __DIR__ . '/vendor/autoload.php';

use Mpdf\Mpdf;
use Mpdf\Config\ConfigVariables;
use Mpdf\Config\FontVariables;

use Endroid\QrCode\Builder\Builder;
use Endroid\QrCode\Writer\PngWriter;
use Endroid\QrCode\Encoding\Encoding;
use Endroid\QrCode\Color\Color;

/* اتصال قاعدة البيانات */
$pdo = db();
if (!($pdo instanceof PDO)) {
  http_response_code(500);
  exit('تعذر الاتصال بقاعدة البيانات: $pdo غير مهيّأ.');
}

/* التحقّق من id */
if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
  exit("<h2 style='color:red; text-align:center;'>⚠️ رقم الشهادة غير صالح.</h2>");
}
$id = (int) $_GET['id'];

/* جلب السجل */
$stmt = $pdo->prepare("SELECT * FROM inspections WHERE id = ? LIMIT 1");
$stmt->execute([$id]);
$cert = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$cert) {
  exit("<h2 style='color:red; text-align:center;'>⚠️ السجل غير موجود.</h2>");
}


/* دالة تهريب HTML */
function h($v) { return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8'); }


/* يلف أي نص فيه ≥ أو ≤ أو < أو > ليُعرَض LTR */
function cmp($v){
  $s = (string)($v ?? '');
  if ($s === '') return '';
  if (preg_match('/[≤≥<>]/u', $s)) {
    return '<span class="cmp-ltr">'.h($s).'</span>';
  }
  return h($s);
}

/* إعدادات mPDF والخطوط */
$defaultConfig     = (new \Mpdf\Config\ConfigVariables())->getDefaults();
$fontDirs          = $defaultConfig['fontDir'];
$defaultFontConfig = (new \Mpdf\Config\FontVariables())->getDefaults();

$fontData = $defaultFontConfig['fontdata'];

// Cairo (عربي)
$fontData['cairo'] = [
  'R' => 'Cairo-Regular.ttf',
  'B' => 'Cairo-SemiBold.ttf',
  'useOTL' => 0xFF,
  'useKashida' => 75,
];

// Times New Roman (إنجليزي)
$fontData['timesnr'] = [
  'R'  => 'times.ttf',
  'B'  => 'timesbd.ttf',
  'I'  => 'timesi.ttf',
  'BI' => 'timesbi.ttf',
];

// ⚠️ حل خطأ DejaVuSerifCondensed:
// لو الملف غير موجود، خليه يُشير لملفات DejaVuSerif العادية.
$fontData['dejavuserifcondensed'] = [
  'R'  => 'DejaVuSerif.ttf',
  'B'  => 'DejaVuSerif-Bold.ttf',
  'I'  => 'DejaVuSerif-Italic.ttf',
  'BI' => 'DejaVuSerif-BoldItalic.ttf',
];

$mpdf = new \Mpdf\Mpdf([
  'mode'        => 'utf-8',
  'format'      => 'A4',
  'orientation' => 'P',
  'margin_left' => 2,
  'margin_right'=> 2,
  'margin_top'  => 12.8,
  'margin_bottom'=> 2,
  // مهم: أضف مجلد مشروعك + اترك مجلدات mPDF الافتراضية
  'fontDir'     => array_merge($fontDirs, [__DIR__ . '/fonts']),
  'fontdata'    => $fontData,
  'default_font'=> 'cairo',
]);

// منع الاستبدالات التلقائية التي قد تسحبك لـ DejaVuCondensed
$mpdf->autoLangToFont = false;
if (property_exists($mpdf, 'useSubstitutions')) {
  $mpdf->useSubstitutions = false;
}

$mpdf->autoScriptToLang = true;
$mpdf->autoLangToFont   = false;
$mpdf->SetDirectionality('rtl');
$mpdf->SetFont('cairo', '', 0, true);


/* خلفية الصفحة */
$mpdf->SetDefaultBodyCSS('background', "url('background.png')");
$mpdf->SetDefaultBodyCSS('background-image-resize', 6);

/* HTML */
ob_start();
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="utf-8">
<style>
  html, body { font-family: 'cairo'; }
  .td-ar { display:block; }
.qr-box{position:absolute; top:24.2mm; left:24mm; width:26mm; height:26mm; z-index:100; display:flex; justify-content:center; align-items:center; background:none; border:none}
  .qr-box img{width:100%; height:100%; object-fit:contain; display:block}

  
  /* تنسيقات معلومات الوثيقة */
  
  .td-ar.docSerialNum{font-size:7.9px; font-weight:normal; text-align:right; letter-spacing: 0.3px; color: #ffffffff; }
  .td-ar.report_type    { font-size:7.9px; font-weight:normal; text-align:right; letter-spacing:0px; color:#fff;  }
  .td-ar.inspAuthDoc    { font-size:7.9px; font-weight:normal; text-align:right; letter-spacing:-0.05px; color:#fff;  }
  .td-ar.inspLoc        { font-size:7.9px; font-weight:normal; text-align:right; letter-spacing:-0.01px; color:#fff;  }
  .td-ar.laneNumDoc     { font-size:7.9px; font-weight:normal; text-align:right; letter-spacing:0.3px; color:#fff;  }
  .td-ar.inspNumDoc     { font-size:7.9px; font-weight:normal; text-align:right; letter-spacing:0.2px; color:#fff;  }
  .td-ar.stickerNum     { font-size:7.9px; font-weight:normal; text-align:right; letter-spacing:0.3px; color:#fff;  }
  .td-ar.attemptNumDoc     { font-size:7.9px; font-weight:normal; text-align:right; letter-spacing:0.3px; color:#fff; }
  .td-ar.underbodyTest  { font-size:8.5px; font-weight:normal; text-align:right; letter-spacing:0.3px; color:#fff;  }
  .td-ar.brakeTest      { font-size:8.5px; font-weight:normal; text-align:right; letter-spacing:0.3px; color:#fff;  }
  .td-ar.extInsp        { font-size:8.5px; font-weight:normal; text-align:right; letter-spacing:0.3px; color:#fff;  }


/* جدول الجانب الأيسر (عمود واحد) */
.table--side            { width:100%; border-collapse:collapse; }
.table--side td { padding: 2mm 2mm; }          /* الأساس */
.table--side td.cell-report_type { padding-top: 2.2mm; }  /* مسافة إضافية لهذا السطر فقط */
.table--side td.cell-inspAuthDoc { padding-top: 2.7mm; }  /* مسافة إضافية لهذا السطر فقط */
.table--side td.cell-inspLoc { padding-top: 2.4mm; }  /* مسافة إضافية لهذا السطر فقط */
.table--side td.cell-laneNumDoc { padding-top: 2.6mm; }  /* مسافة إضافية لهذا السطر فقط */
.table--side td.cell-inspNumDoc { padding-top: 2.4mm; }  /* مسافة إضافية لهذا السطر فقط */
.table--side td.cell-stickerNum { padding-top: 2.4mm; }  /* مسافة إضافية لهذا السطر فقط */
.table--side td.cell-attemptNumDoc { padding-top: 2.4mm; }  /* مسافة إضافية لهذا السطر فقط */
.table--side td.cell-underbodyTest { padding-top: 11.6mm; padding-right:104px;}  /* مسافة إضافية لهذا السطر فقط */
.table--side td.cell-brakeTest { padding-top: 3.5mm; padding-right:104px;}  /* مسافة إضافية لهذا السطر فقط */
.table--side td.cell-extInsp { padding-top: 7.7mm; padding-right:104px;}  /* مسافة إضافية لهذا السطر فقط */


    /* بيانات المركبة */

  .val-ar.plate_number        { font-size:9px; font-weight:normal; text-align:right; letter-spacing:0.2px; color: #555555;}
  .val-ar.vehicle_brand        { font-size:9px; font-weight:normal; text-align:right; letter-spacing:0.2px; color: #555555; }
  .val-ar.vehicle_model        { font-size:9px; font-weight:normal; text-align:right; letter-spacing:0.2px; color: #555555; }
  .val-ar.odometer        { font-size:9px; font-weight:normal; text-align:right; letter-spacing:0.4px; color: #b0302e; }
  .val-ar.chassis_number        { font-size:9px; font-weight:normal; text-align:right; letter-spacing:0.2px; color: #555555; }
  .val-ar.model_year        { font-size:9px; font-weight:normal; text-align:right; letter-spacing:0.2px; color: #555555; }
  .val-ar.vehicle_color        { font-size:9px; font-weight:normal; text-align:right; letter-spacing:0.2px; color: #555555;}
  .val-ar.serial_number        { font-size:9px; font-weight:normal; text-align:right; letter-spacing:0.2px; color: #555555; }
 
  
.table--styled    { width:100%; border-collapse:collapse; }
.table--styled td { padding: 2mm 2mm; }          /* الأساس */

.table--styled td.plate_number { padding-top: -0.5mm; padding-right:0mm;}  /* مسافة إضافية لهذا السطر فقط */ 
.table--styled td.vehicle_brand { padding-top: -0.5mm; padding-right:0mm;}  /* مسافة إضافية لهذا السطر فقط */
.table--styled td.vehicle_model { padding-top: -0.5mm; padding-right:0mm;}  /* مسافة إضافية لهذا السطر فقط */
.table--styled td.odometer { padding-top: -0.5mm; padding-right:0mm;}  /* مسافة إضافية لهذا السطر فقط */
.table--styled td.chassis_number { padding-top:-0.8mm; padding-right:20.5mm;}  /* مسافة إضافية لهذا السطر فقط */
.table--styled td.model_year { padding-top: -0.5mm; padding-right:20.5mm;}  /* مسافة إضافية لهذا السطر فقط */
.table--styled td.vehicle_color { padding-top:-0.5mm; padding-right:20.5mm;}  /* مسافة إضافية لهذا السطر فقط */
.table--styled td.serial_number { padding-top:-0.3mm; padding-right:20.5mm;}  /* مسافة إضافية لهذا السطر فقط */


  
  .td-ar { display:block; }

  /* توزيع جانبي: يسار (جدول واحد عمود) + يمين (باقي الجداول) */
.layout-wrap            { width:100%; border-collapse:collapse; }
.layout-side-cell       {  width:45%; vertical-align:top; padding-right:2.7mm; padding-top:49.5px; }
.layout-main-cell       { width:45%; vertical-align:top; padding-top:72px;padding-right:-24mm;}



  /* اتجاهات القيم */
  .val-ar { direction:rtl; text-align:right; font-size:9px; width:50%; }
  /* توحيد الانجليزي ليكون مثل العربي */
  .layout-main-cell .custom-table.table--two.table--styled td.val-en{
    direction: rtl;
    text-align: right;
    unicode-bidi: embed;
    font-size:9px;
    width:50%;    
    
}



.table-wrap{
  direction: rtl;              /* مهم عشان flex-start = يمين */
  display: flex;
  justify-content: flex-start; /* يثبت المحتوى يمين */
}
.table-wrap--right{ padding-right: 50px; } /* مسافة عن الحافة (اختياري) */

/* دمج التاريخين وفاصل مرئي في mPDF */

/* اجعل الخلية نفسها LTR ويسار وأزل أي حافة يسار */
.date-cell{
  direction: ltr;
  text-align: right;
  padding-left: 0;   /* مهم لإزالة “الدخلة” */
  color: #ffffffff;
  font-size:8px; 
  letter-spacing: -0.15px;  
  
}

/* تنسيق الحاوية */
.date-combined{
  display: inline-flex;
  align-items: baseline;
  white-space: nowrap;
  
}

/* الفاصل بدون حرف | لتفادي المسافات الجانبية */
.date-combined .bar{
  display:inline-block; width: 0.5px; height:12pt;
  background: currentColor; margin:0 6pt; vertical-align:middle;
}


.date-cell2{
  direction: ltr;
  text-align: right;
  color: #0096b6;
  font-size:8px; 
  letter-spacing: 0px;  
}

/* تنسيق الحاوية */
.date-combined2{
  display: inline-flex;
  align-items: baseline;
  white-space: nowrap;
  
}

/* جدول 5 أعمدة مع عمود فاصل بالمنتصف */
.custom-table { border-collapse:collapse; table-layout:fixed; }
.custom-table.five-cols td{  
  text-align: center;         /* توسيط أفقي */
  vertical-align: middle;     /* توسيط عمودي */
  border: 0mm solid ;
  
}

/* عمود الفاصل: بدون حدود ولا حشو */
.custom-table.five-cols td.mid-gap{
  border: none !important;
  padding: 0 !important;
}

/* صف المُقيّس: مخفي لكن يفرض عرض الأعمدة على mPDF */
.custom-table.five-cols tr.sizer td{
  height:0; line-height:0; padding:0 !important; border:none !important;
  font-size:0; /* ما يطبع نص */
}

/* هامش علوي */
.mt-1mm{ margin-top:23.2mm !important; }

/* اتجاهات */
.custom-table.five-cols{ direction: rtl; } /* تحكم باتجاه الجدول نفسه */
.td-ar{ direction: rtl; text-align: center; }
.td-en{ direction: rtl; unicode-bidi: embed; text-align: center; } /* خليت الإنجليزي نفس اتجاه العربي كما طلبت سابقاً */

 /* الجدول: نستخدم collapse ونلغي أي border-spacing عشان ما تتداخل مع الفواصل اليدوية */
  .custom-table.five-cols{
    border-collapse: collapse !important;
    table-layout: fixed;
    width: auto;
  }
  .custom-table.five-cols td{
    padding: 2mm 2.3mm;
    text-align: center;
    vertical-align: middle;
    border: 0mm solid ;
    font-size: 9px;
    background: #;
    
  }

  /* صف قياس الأعمدة (لا يظهر ولا يأخذ مساحة) */
  .custom-table.five-cols tr.sizer td{
    height: 0 !important;
    padding: 0 !important;
    border: none !important;
    line-height: 0 !important;
  }

  /* صف الفاصل بين الصفوف: خلية واحدة تمتد على الأعمدة الخمسة */
  .custom-table.five-cols tr.spacer td{
    padding: 0 !important;
    border: none !important;
    height: 62.5;          /* الأساس */
    line-height: 0;
    background: transparent !important;
  }


  /* عند وجود رموز مقارنة (≥ ≤) نجبر الاتجاه LTR لكي لا تنعكس */
  .cmp-ltr {
    direction: ltr !important;
    unicode-bidi: embed !important;
    display: inline-block;
  }

/* الأعمدة العربية */
.custom-table.five-cols td.col-ar2,
.custom-table.five-cols td.col-en2 {
  font-family: 'cairo' !important;
  direction: rtl;
  unicode-bidi: embed;
  text-align: center;
   padding: 1.5mm 1mm;
   font-size: 8px;
   color: #555555;
}

/* الأعمدة الإنجليزية (تايمز) */
.custom-table.five-cols td.col-ar1,
.custom-table.five-cols td.col-en1 {
  font-family: 'timesnr' !important;  /* نفس alias المسجل */
  direction: ltr;                      /* أو rtl حسب ما تريد */
  unicode-bidi: embed;
  text-align: center;
   padding: 1.5mm 1mm;
   font-size: 8px;
   font-weight: bold;
  }



</style>
</head>
<body>

<div class="page1">

  <!-- حاوية التوزيع: عمودان -->
<table class="layout-wrap" style="width:100%; table-layout:fixed; border-collapse:collapse;">
  <tr>

    <!-- العمود الأيسر: جدول جانبي بعمود واحد -->
     <td class="layout-side-cell" style="width540mm; min-width:54mm; max-width:54mm; vertical-align:top;">
       <table class="custom-table table--side">
        <tr><td><span class="td-ar docSerialNum"><?= ($cert['docSerialNum'] ?? '') ?></span></td></tr>
<tr>
  <td class="date-cell" style="padding-top: 2.5mm;">
    <span class="date-combined">
      <bdi class="greg" dir="ltr">
        <?= !empty($cert['inspDateGregorian']) ? date('d-m-Y', strtotime($cert['inspDateGregorian'])) : '' ?>
      </bdi>
      <span class="bar">|</span>
      <bdi class="hijri" dir="ltr">
        <?= ($cert['inspDateHijri'] ?? '') ?>
      </bdi>
    </span>
  </td>
</tr>
<tr><td class="cell-report_type"><span class="td-ar report_type"><?= ($cert['report_type'] ?? '') ?></span></td></tr>
<tr><td class="cell-inspAuthDoc"><span class="td-ar inspAuthDoc"><?= ($cert['inspAuthDoc'] ?? '') ?></span></td></tr>
<tr><td class="cell-inspLoc"><span class="td-ar inspLoc"><?= ($cert['inspLoc'] ?? '') ?></span></td></tr>
<tr><td class="cell-laneNumDoc"><span class="td-ar laneNumDoc"><?= ($cert['laneNumDoc'] ?? '') ?></span></td></tr>
<tr><td class="cell-inspNumDoc"><span class="td-ar inspNumDoc"><?= ($cert['inspNumDoc'] ?? '') ?></span></td></tr>
<tr><td class="cell-stickerNum"><span class="td-ar stickerNum"><?= ($cert['stickerNum'] ?? '') ?></span></td></tr>
<tr><td class="cell-attemptNumDoc"><span class="td-ar attemptNumDoc"><?= ($cert['attemptNumDoc'] ?? '') ?></span></td></tr>
       
<tr>
  <td class="date-cell2" style="padding-top: 5.6mm; padding-right:3.5mm;">
    <span class="date-combined2">
      <bdi class="greg" dir="ltr">
        <?= !empty($cert['inspectionExpiryDate']) ? date('d-m-Y', strtotime($cert['inspectionExpiryDate'])) : '' ?>
      </bdi>
      <span class="bar">|</span>
      <bdi class="hijri" dir="ltr">
        <?= ($cert['validUntilDocHijri'] ?? '') ?>
      </bdi>
    </span>
  </td>
</tr>       

<tr><td class="cell-underbodyTest"><span class="td-ar underbodyTest"><?= ($cert['underbodyTest'] ?? '') ?></span></td></tr>
<tr><td class="cell-brakeTest"><span class="td-ar brakeTest"><?= ($cert['brakeTest'] ?? '') ?></span></td></tr>
<tr><td class="cell-extInsp"><span class="td-ar extInsp"><?= ($cert['extInsp'] ?? '') ?></span></td></tr>        
      </table>
    </td>

      <!-- العمود الأيمن: إزاحة لليسار عبر margin-right (لا تؤثر على العرض) -->
      <td class="layout-main-cell">
  <div class="main-inner">
    <table class="custom-table table--two table--styled"
           style="width:100%; table-layout:fixed; border-collapse:collapse;">

   
      <colgroup>
        <col style="width:50%" />
        <col style="width:50%" />
      </colgroup>

      <tbody>
        <tr>
          <td class="val-ar plate_number"><?= h($cert['plateNum'] ?? '') ?></td>
          <td class="val-ar chassis_number"><?= h($cert['chassisNum'] ?? '') ?></td>
        </tr>
        <tr>
          <td class="val-ar vehicle_brand"><?= h($cert['manufacturer'] ?? '') ?></td>
          <td class="val-ar model_year"><?= h($cert['modelYear'] ?? '') ?></td>
        </tr>
        <tr>
          <td class="val-ar vehicle_model"><?= h($cert['model'] ?? '') ?></td>
          <td class="val-ar vehicle_color"><?= h($cert['color'] ?? '') ?></td>
        </tr>
        <tr>
          <td class="val-ar odometer"><?= h($cert['odometer'] ?? '') ?></td>
          <td class="val-ar serial_number"><?= h($cert['serialNum'] ?? '') ?></td>
        </tr>        
            </tr>
          </table>
        </div>
      </td>


    <table class="custom-table five-cols mt-1mm" style="width:auto; margin-right:14.5mm;">
  <tbody>
    <!-- صف مُقَيِّس لفرض عرض الأعمدة (عدّل الأرقام كما تريد) -->
    <tr class="sizer">
      <td style="width:10mm"></td>   <!-- عربي 1 -->
      <td style="width:7mm"></td>   <!-- عربي 2 -->
      <td style="width:59.5mm"></td>  <!-- الفاصل -->
      <td style="width 10mm"></td>   <!-- إنجليزي 1 -->
      <td style="width:7mm"></td>   <!-- إنجليزي 2 -->
    </tr>

    <!-- Side Slip -->
    <tr>
      <td class="td-ar col-ar1"><?= h($cert[''] ?? '') ?></td>
      <td class="td-ar col-ar2"><?= cmp($cert['sideSlipPass'] ?? '') ?></td>
   
    </tr>

    <tr class="spacer sp-2mm"><td colspan="5"></td></tr>  <!-- مسافة 2مم بعد الصف -->
    <!-- Brakes - Front -->
    <tr>
      
      <td class="td-ar col-ar1"><?= h($cert['frontBrakeEff'] ?? '') ?></td>
      <td class="td-ar col-ar2"><?= cmp($cert['frontBrakePass'] ?? '') ?></td>
      <td class="mid-gap">&nbsp;</td>
      <td class="td-en col-en1"><?= h($cert[''] ?? '') ?></td>
      <td class="td-en col-en2"><?= cmp($cert['frontBrakePass'] ?? '') ?></td>
    </tr>
    <tr>
      <td class="td-ar col-ar1"><?= h($cert['frontBrakeImb'] ?? '') ?></td>
      <td class="td-ar col-ar2"><?= cmp($cert['frontBrakeImbPass'] ?? '') ?></td>
      <td class="mid-gap">&nbsp;</td>
      <td class="td-en col-en1"><?= h($cert[''] ?? '') ?></td>
      <td class="td-en col-en2"><?= cmp($cert[''] ?? '') ?></td>
    </tr>
    <tr>
      <td class="td-ar col-ar1"><?= h($cert['frontBrakeFric'] ?? '') ?></td>
      <td class="td-ar col-ar2"><?= cmp($cert['frontBrakeFricPass'] ?? '') ?></td>
      <td class="mid-gap">&nbsp;</td>
      <td class="td-en col-en1"><?= h($cert[''] ?? '') ?></td>
      <td class="td-en col-en2"><?= cmp($cert['frontBrakeFricPass'] ?? '') ?></td>
    </tr>

    <!-- Brakes - Rear -->
    <tr>
      <td class="td-ar col-ar1"><?= h($cert['rearBrakeEff'] ?? '') ?></td>
      <td class="td-ar col-ar2"><?= cmp($cert['rearBrakePass'] ?? '') ?></td>
      <td class="mid-gap">&nbsp;</td>
      <td class="td-en col-en1"><?= h($cert['rearBrakeEff'] ?? '') ?></td>
      <td class="td-en col-en2"><?= cmp($cert['rearBrakePass'] ?? '') ?></td>
    </tr>
    <tr>
      <td class="td-ar col-ar1"><?= h($cert['rearBrakeImb'] ?? '') ?></td>
      <td class="td-ar col-ar2"><?= cmp($cert['frontBrakeImbPass'] ?? '') ?></td>
      <td class="mid-gap">&nbsp;</td>
      <td class="td-en col-en1"><?= h($cert['rearBrakeFric'] ?? '') ?></td>
      <td class="td-en col-en2"><?= cmp($cert['frontBrakeImbPass'] ?? '') ?></td>
    </tr>
    <tr>
      <td class="td-ar col-ar1"><?= h($cert['rearBrakeFric'] ?? '') ?></td>
      <td class="td-ar col-ar2"><?= cmp($cert['rearBrakeFricPass'] ?? '') ?></td>
      <td class="mid-gap">&nbsp;</td>
      <td class="td-en col-en1"><?= h($cert['rearBrakeFric'] ?? '') ?></td>
      <td class="td-en col-en2"><?= cmp($cert['rearBrakeFricPass'] ?? '') ?></td>
    </tr>
      <tr>
      <td class="td-ar col-ar1"><?= h($cert['handBrakeEff'] ?? '') ?></td>
      <td class="td-ar col-ar2"><?= cmp($cert['handBrakePass'] ?? '') ?></td>
      <td class="mid-gap">&nbsp;</td>
      <td class="td-en col-en1"><?= h($cert[''] ?? '') ?></td>
      <td class="td-en col-en2"><?= cmp($cert[''] ?? '') ?></td>
    </tr>

    <!-- Exhaust / Smoke / HC -->
    <tr>
      <td class="td-ar col-ar1"><?= h($cert['coLevel'] ?? '') ?></td>
      <td class="td-ar col-ar2"><?= cmp($cert['coPass'] ?? '') ?></td>
      <td class="mid-gap">&nbsp;</td>
      <td class="td-en col-en1"><?= h($cert['coLevel'] ?? '') ?></td>
      <td class="td-en col-en2"><?= cmp($cert['coPass'] ?? '') ?></td>
    </tr>
    <tr>
      <td class="td-ar col-ar1"><?= h($cert['smokeDensity'] ?? '') ?></td>
      <td class="td-ar col-ar2"><?= cmp($cert['smokePass'] ?? '') ?></td>
      <td class="mid-gap">&nbsp;</td>
      <td class="td-en col-en1"><?= h($cert['smokeDensity'] ?? '') ?></td>
      <td class="td-en col-en2"><?= cmp($cert['smokePass'] ?? '') ?></td>
    </tr>
    <tr>
      <td class="td-ar col-ar1"><?= h($cert['hcLevel'] ?? '') ?></td>
      <td class="td-ar col-ar2"><?= cmp($cert['hcPass'] ?? '') ?></td>
      <td class="mid-gap">&nbsp;</td>
      <td class="td-en col-en1"><?= h($cert['hcLevel'] ?? '') ?></td>
      <td class="td-en col-en2"><?= cmp($cert['hcPass'] ?? '') ?></td>
    </tr>
  </tbody>
</table>

   </tr>        
            </tr>
          </table>
        </div>
      </td>

</body>
</html>
<?php
$html = ob_get_clean();        // خذ الـHTML بدون ما ترسله للمتصفح
$mpdf->WriteHTML($html);

/* مهم: امنع أي مخرجات مفاجئة وقت الإخراج */
$prevDisplay = ini_get('display_errors');
ini_set('display_errors', '0');

/* نظّف أي buffers مفتوحة (لو فيه مسافات/تحذيرات انطبعت) */
while (ob_get_level() > 0) { ob_end_clean(); }

/* ===== 1) توليد اسم الملف: (رقم اللوحة) - (نوع الوثيقة).pdf ===== */

// رقم اللوحة (ندعم عمودين محتملين plateNum/plate_number + تطبيع الأرقام العربية)
$plate_number_raw = trim($cert['plateNum'] ?? $cert['plate_number'] ?? '');
if ($plate_number_raw === '') {
    $plate_number_raw = 'بدون-لوحة';
}
$plate_number = strtr($plate_number_raw, [
    '٠'=>'0','١'=>'1','٢'=>'2','٣'=>'3','٤'=>'4',
    '٥'=>'5','٦'=>'6','٧'=>'7','٨'=>'8','٩'=>'9'
]);
$plate_number = preg_replace('/\s+/u', ' ', $plate_number);
$plate_number = trim($plate_number);

// نوع الوثيقة (خذ من قاعدة البيانات إن وُجد وإلا استخدم نصًا ثابتًا)
$doc_type = trim('وثيقة الفحص الدوري');

// تركيب الاسم وتنظيفه من محارف غير صالحة للأسماء
$proposed_name = $plate_number . ' - ' . $doc_type;
$clean_name = preg_replace('/[\\\\\/:*?"<>|]/u', '_', $proposed_name);
$clean_name = preg_replace('/\s+/u', ' ', $clean_name);
$clean_name = preg_replace('/_+/u', '_', $clean_name);
$clean_name = trim($clean_name, " \t\n\r\0\x0B-_");

// اسم الملف النهائي
$custom_filename = $clean_name . '.pdf';

// مجلد الحفظ temp/
$dir = __DIR__ . '/temp';
if (!is_dir($dir)) {
    mkdir($dir, 0777, true);
}
$save_path = $dir . '/' . $custom_filename;

/* ===== 2) حفظ الـ PDF على القرص ===== */
$mpdf->Output($save_path, \Mpdf\Output\Destination::FILE);

/* ===== 3) بناء رابط عام وفتح نافذة الطباعة داخل IFRAME ===== */
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
$host     = $_SERVER['HTTP_HOST'];
$basePath = rtrim(dirname($_SERVER['PHP_SELF']), '/');
$public_url = $protocol . '://' . $host . $basePath . '/temp/' . rawurlencode($custom_filename);

// أعِد تفعيل عرض الأخطاء لو حاب ترجع الإعداد كما كان
ini_set('display_errors', $prevDisplay);

/* ===== 4) صفحة عرض/طباعة الملف المحفوظ ===== */
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <title><?= htmlspecialchars($doc_type, ENT_QUOTES, 'UTF-8') ?></title>
  <style>
    html, body { margin: 0; height: 100%; overflow: hidden; background:#f7f7f7; }
    iframe { width: 100%; height: 100%; border: none; }
  </style>
</head>
<body>
  <iframe id="pdfFrame"
          src="<?= htmlspecialchars($public_url, ENT_QUOTES, 'UTF-8') . '?v=' . time() ?>">
  </iframe>
  <script>
    const f = document.getElementById('pdfFrame');
    // عند تحميل الـPDF داخل الإطار، نفّذ الطباعة
    f.addEventListener('load', () => {
      setTimeout(() => {
        try { f.contentWindow?.focus(); f.contentWindow?.print(); } catch(e) {}
      }, 800);
    });
  </script>
</body>
</html>
<?php
exit;