<?php
// /.details/get_details_by_sn.php
header('Content-Type: application/json; charset=utf-8');

require __DIR__ . '/../config.php';
$pdo = db();
if (!($pdo instanceof PDO)) {
  http_response_code(500);
  echo json_encode(['ok'=>false, 'msg'=>'DB error'], JSON_UNESCAPED_UNICODE);
  exit;
}

$sn = isset($_GET['sn']) ? trim($_GET['sn']) : '';
if ($sn === '') {
  echo json_encode(['ok'=>false, 'msg'=>'missing sn'], JSON_UNESCAPED_UNICODE);
  exit;
}

// يمكنك هنا أيضاً قراءة من كعكة (كوكي) لو كنت تحفظها في search_result.php
// ثم إن لم توجد الكوكي نرجع للداتابيس:
$stmt = $pdo->prepare("
  SELECT plateNum, chassisNum, serialNum,
         manufacturer, model,
         inspDateGregorian, inspLoc, report_type,
         inspectionExpiryDate
  FROM inspections
  WHERE sn = ?
  ORDER BY id DESC
  LIMIT 1
");
$stmt->execute([$sn]);
$row = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$row) {
  echo json_encode(['ok'=>false, 'msg'=>'not found'], JSON_UNESCAPED_UNICODE);
  exit;
}

echo json_encode(['ok'=>true, 'data'=>$row], JSON_UNESCAPED_UNICODE);
